/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import noppes.npcs.api.IPos;
import noppes.npcs.api.util.IRayTraceRotate;
import noppes.npcs.api.wrapper.BlockPosWrapper;

public class RayTraceRotate
implements IRayTraceRotate {
    public static RayTraceRotate EMPTY = new RayTraceRotate();
    private double yaw = 0.0;
    private double pitch = 0.0;
    private double radiusXZ = 0.0;
    private double distance = 0.0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sz = 0.0;

    public void calculate(double dx, double dy, double dz, double mx, double my, double mz) {
        this.sx = dx;
        this.sy = dy;
        this.sz = dz;
        this.x = mx;
        this.y = my;
        this.z = mz;
        double xVal = mx - dx;
        double yVal = my - dy;
        double zVal = mz - dz;
        this.radiusXZ = Math.sqrt(Math.pow(xVal, 2.0) + Math.pow(zVal, 2.0));
        this.distance = Math.sqrt(Math.pow(this.radiusXZ, 2.0) + Math.pow(yVal, 2.0));
        double rad = 57.29577951308232;
        this.pitch = -Math.atan(yVal / this.radiusXZ) * rad;
        if (Float.isNaN((float)this.pitch)) {
            this.pitch = 0.0;
        }
        if (this.pitch < -90.0) {
            this.pitch = -90.0;
        }
        if (this.pitch > 90.0) {
            this.pitch = 90.0;
        }
        if (xVal == 0.0) {
            this.yaw = dz > mz ? 180.0 : 0.0;
        } else {
            double v = Math.atan(zVal / xVal) * rad;
            this.yaw = xVal <= 0.0 ? 90.0 + v : 270.0 + v;
        }
        if (Float.isNaN((float)this.yaw)) {
            this.yaw = 0.0;
        }
        this.yaw %= 360.0;
        if (this.yaw < 0.0) {
            this.yaw += 360.0;
        }
    }

    @Override
    public double getYaw() {
        return this.yaw;
    }

    @Override
    public double getPitch() {
        return this.pitch;
    }

    @Override
    public double getRadiusXZ() {
        return this.radiusXZ;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public IPos getStartPos() {
        return new BlockPosWrapper(this.sx, this.sy, this.sz);
    }

    @Override
    public IPos getEndPos() {
        return new BlockPosWrapper(this.x, this.y, this.z);
    }
}

